//=============================================================================
// WorkBenchMenuMain
//=============================================================================

class WorkBenchMenuCustomRifleAmmo expands MenuUIWindow;

//Universals
var DeusExPlayer Player;
var PartsBag Bench;
var MSMassEffectMutator Mutator;

//Window Specifics
var MenuUIActionButtonWindow exitButton;
var localized string exitButtonText;

var NextPartButton2 UpButton[3];
var PrevPartButton2 DownButton[3];

var CraftingPowder CurPowder;
var CraftingCasing CurCasing;
var CraftingTipping CurTipping;

var Window Overlay1;
var Window PowderDisplay, CasingDisplay, TippingDisplay;

var ModifiedPersonaTextWindow  StatDisplay, NamePointer;
var ModifiedPersonaTextWindow Quantities[3];
var MenuUIEditWindow CustomNameField;

var PersonaActionButtonWindow CreateButton;

var Window Last;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------


function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 return false;
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 return false;
}

event InitWindow()
{
 local int i, j;

	Super.InitWindow();
        SetTitle("Custom Rifle Creation");
        exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);
	
	CreateOverlays();
	CreateButtons();
	CreateTextDisplay();

	CustomNameField = CreateMenuEditWindow(352, 272, 132, 24, winClient);
	CustomNameField.SetText("Custom Ammo X");
}

function CreateTextDisplay()
{
 StatDisplay = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 StatDisplay.SetPos(16, 268);
 StatDisplay.SetSize(240, 96);
 StatDisplay.SetFont(Font'FontMenuHeaders');

 NamePointer = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 NamePointer.SetPos(296, 284);
 NamePointer.SetSize(72, 40);
 NamePointer.SetFont(Font'FontMenuHeaders');
 NamePointer.SetText("|p4NAME IT! >");

 Quantities[0] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Quantities[0].SetPos(133, 33);
 Quantities[0].SetSize(25, 40);
 Quantities[0].SetFont(Font'FontMenuHeaders');
 Quantities[1] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Quantities[1].SetPos(133, 121);
 Quantities[1].SetSize(25, 40);
 Quantities[1].SetFont(Font'FontMenuHeaders');
 Quantities[2] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Quantities[2].SetPos(133, 215);
 Quantities[2].SetSize(25, 40);
 Quantities[2].SetFont(Font'FontMenuHeaders');
}

function CreateButtons()
{
 	UpButton[0] = NextPartButton2(NewChild(Class'NextPartButton2'));
	UpButton[0].SetPos(151, 33);
 	UpButton[1] = NextPartButton2(NewChild(Class'NextPartButton2'));
	UpButton[1].SetPos(150, 121);
 	UpButton[2] = NextPartButton2(NewChild(Class'NextPartButton2'));
	UpButton[2].SetPos(163, 215);
	
 	DownButton[0] = PrevPartButton2(NewChild(Class'PrevPartButton2'));
	DownButton[0].SetPos(98, 33);
 	DownButton[1] = PrevPartButton2(NewChild(Class'PrevPartButton2'));
	DownButton[1].SetPos(97, 121);
 	DownButton[2] = PrevPartButton2(NewChild(Class'PrevPartButton2'));
	DownButton[2].SetPos(88, 215);
	
	CreateButton = PersonaActionButtonWindow(NewChild(Class'PersonaActionButtonWindow'));
	CreateButton.SetPos(448, 368);
	CreateButton.SetButtonText("CREATE!");
	CreateButton.SetSensitivity(False);
}

function CreateOverlays()
{
	Overlay1 = NewChild(Class'Window');
	SetupOverlay(Overlay1, 0, 0, 256, 256);
	Overlay1.SetBackground(Texture'WorkbenchAmmoOverlay1');
	
	PowderDisplay = NewChild(Class'Window');
	SetupOverlay(PowderDisplay, 0, 0, 256, 256);
	CasingDisplay = NewChild(Class'Window');
	SetupOverlay(CasingDisplay, 0, 0, 256, 256);
	TippingDisplay = NewChild(Class'Window');
	SetupOverlay(TippingDisplay, 0, 0, 256, 64);
}

function SetupOverlay(Window Win, int PosX, int PosY, int WidthX, int HeightY)
{
	win.SetBackgroundStyle(DSTY_Masked);
	win.SetPos(PosX, PosY);
	win.SetSize(WidthX, HeightY);
}

function UpdateIcons()
{
 if (CurPowder != None && !CurPowder.bDeleteMe) PowderDisplay.SetBackground(CurPowder.BenchIcon);
 if (CurCasing != None && !CurCasing.bDeleteMe) CasingDisplay.SetBackground(CurCasing.BenchIcon);
 if (CurTipping != None && !CurTipping.bDeleteMe) TippingDisplay.SetBackground(CurTipping.BenchIcon);
 
 UpdateStats();
}

function UpdateStats()
{
 
 if (CurPowder != None && CurCasing != None && CurTipping != None) CreateButton.SetSensitivity(True);
 if (CurPowder == None || CurCasing == None || CurTipping == None) CreateButton.SetSensitivity(False);
 if (CurPowder.bDeleteMe || CurCasing.bDeleteMe || CurTipping.bDeleteMe) CreateButton.SetSensitivity(False);
 
 if (CurPowder != None && !CurPowder.bDeleteMe) Quantities[2].SetText(String(CurPowder.NumCopies));
 if (CurCasing != None && !CurCasing.bDeleteMe) Quantities[1].SetText(String(CurCasing.NumCopies));
 if (CurTipping != None && !CurTipping.bDeleteMe) Quantities[0].SetText(String(CurTipping.NumCopies));
 
 if (CurPowder == None || CurPowder.bDeleteMe) Quantities[2].SetText("");
 if (CurCasing == None || CurCasing.bDeleteMe) Quantities[1].SetText("");
 if (CurTipping == None || CurTipping.bDeleteMe) Quantities[0].SetText("");
 
 StatDisplay.SetText(BuildAmmoStats());
}

simulated function String FormatFloatString(float value, float precision)
{
	local string str;

	if (precision == 0.0)
		return "ERR";

	// build integer part
	str = String(Int(value));

	// build decimal part
	if (precision < 1.0)
	{
		value -= Int(value);
		str = str $ "." $ String(Int((0.5 * precision) + value * (1.0 / precision)));
	}

	return str;
}

function CreateAmmo()
{
 local AmmoCombatRifle C;
 
 local string Special, VSBonus;
 local int NumProjectiles, Caliber;
 
 if (CurPowder == None || CurCasing == None || CurTipping == None) return;
 if (CurPowder.bDeleteMe || CurCasing.bDeleteMe || CurTipping.bDeleteMe) return;
 
 Special = CurPowder.Special;
 VsBonus = CurTipping.VsBonus;
 

 Caliber = CurCasing.CaliberType;
 NumProjectiles = CurTipping.NumProjectiles;
 
 C = Bench.Spawn(class'AmmoCombatRifle',,,Bench.Location + vect(0,0,30));
 
 C.Special = Special;
 C.VSBonus = VSBonus;

 C.Caliber = Caliber;
 C.NumProjectiles = NumProjectiles;

 C.CustomName = CustomNameField.GetText();
 
 C.UpdateName();

 CurPowder.UseOnce();
 CurCasing.UseOnce();
 CurTipping.UseOnce();
 
 CreateButton.SetSensitivity(False);
 
 UpdateIcons();
 ClearIcons();
 
 Bench.PlaySound(Sound'BreakdownPart');
 
 C.Frob(Player, None);
}

function ClearIcons()
{
 if (CurPowder == None || CurPowder.bDeleteMe) PowderDisplay.SetBackground(None);
 if (CurCasing == None || CurCasing.bDeleteMe) CasingDisplay.SetBackground(None);
 if (CurTipping == None || CurTipping.bDeleteMe) TippingDisplay.SetBackground(None);
}

function String BuildAmmoStats()
{
 local string S, Special, VSBonus, Caliber;
 local int NumProjectiles;
 
 if (CurPowder == None && CurCasing == None && CurTipping == None) return "";
 if (CurPowder.bDeleteMe && CurCasing.bDeleteMe && CurTipping.bDeleteMe) return "";
 
 if (CurPowder != None) 
 {
  if (CurPowder.Special != "") Special = "Special: "$CurPowder.Special;
 }
 if (CurCasing != None)
 {
  Caliber = "Caliber: "$FormatFloatString(float(CurCasing.CaliberType) / 100, 0.01)$"mm";
 }
 if (CurTipping != None)
 {
  NumProjectiles = CurTipping.NumProjectiles;
  if (CurTipping.VSBonus != "" && CurPowder.Special != "") VSBonus = ", ";
  if (CurTipping.VSBonus != "") VSBonus = VSBonus$"+VS "$CurTipping.VSBonus;
 }
 
 S = Caliber@NumProjectiles$" Shot(s)"$CR()$Special$VSBonus;
 
 return S;
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch(buttonPressed)
	{
		case exitButton:
			//Ralph.ChargeTheGates(TempName);
			// Do stuff

			Last.Show(True);

			root.PopWindow();
			bHandled = True;
			break;

		case UpButton[0]:
			NextTipping();
			bHandled = True;
			break;
		case UpButton[1]:
			NextCasing();
			bHandled = True;
			break;
		case UpButton[2]:
			NextPowder();
			bHandled = True;
			break;

		case DownButton[0]:
			PrevTipping();
			bHandled = True;
			break;
		case DownButton[1]:
			PrevCasing();
			bHandled = True;
			break;
		case DownButton[2]:
			PrevPowder();
			bHandled = True;
			break;

		case CreateButton:
			CreateAmmo();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	/*if (ButtonPressed != exitButton)
	{
		UpdateInfo();
	}*/

	return bHandled;
}

//==================================================
//++++++++++++++++++++++++++++++++++++++++++++++++++
//NEXT PART FUNCTIONS BEGIN
//++++++++++++++++++++++++++++++++++++++++++++++++++
//==================================================

function NextPowder()
{
 local CraftingPowder P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'CraftingPowder', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurPowder == None)
   {
    Pick = First;
    break;
   }
   
   if (P == CurPowder) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 CurPowder = Pick;
 UpdateIcons();
}

function NextCasing()
{
 local RifleCasing P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'RifleCasing', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurCasing == None)
   {
    Pick = First;
    break;
   }
   
   if (P == CurCasing) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 CurCasing = Pick;
 UpdateIcons();
}

function NextTipping()
{
 local RifleTipping P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'RifleTipping', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurTipping == None)
   {
    Pick = First;
    break;
   }
   
   if (P == CurTipping) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 CurTipping = Pick;
 UpdateIcons();
}

//==================================================
//++++++++++++++++++++++++++++++++++++++++++++++++++
//NEXT PART FUNCTIONS END
//++++++++++++++++++++++++++++++++++++++++++++++++++
//==================================================

//==================================================
//--------------------------------------------------
//PREV PART FUNCTIONS BEGIN
//--------------------------------------------------
//==================================================

function PrevPowder()
{
 local CraftingPowder P, Pick, First, Last;
 
 forEach Player.AllActors(class'CraftingPowder', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   
   if (P == CurPowder && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurPowder == None || Pick == None)
 {
  Pick = Last;
 }

 CurPowder = Pick;
 UpdateIcons();
}

function PrevCasing()
{
 local RifleCasing P, Pick, First, Last;
 
 forEach Player.AllActors(class'RifleCasing', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   
   if (P == CurCasing && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurCasing == None || Pick == None)
 {
  Pick = Last;
 }

 CurCasing = Pick;
 UpdateIcons();
}

function PrevTipping()
{
 local RifleTipping P, Pick, First, Last;
 
 forEach Player.AllActors(class'RifleTipping', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   
   if (P == CurTipping && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurTipping == None || Pick == None)
 {
  Pick = Last;
 }

 CurTipping = Pick;
 UpdateIcons();
}

//==================================================
//--------------------------------------------------
//PREV PART FUNCTIONS END
//--------------------------------------------------
//==================================================

defaultproperties
{

     Title="Custom Rifle Creation"
     exitButtonText="Done"
     ClientWidth=512
     ClientHeight=384

     clientTextures(0)=Texture'WorkBenchAmmoBG1'
     clientTextures(1)=None
     clientTextures(2)=Texture'WorkBenchRifleBG3'
     clientTextures(3)=Texture'WorkBenchRifleBG4'

     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=2
     exitButtonText="Cancel"

}
